#include "g_local.h"
#include "m_player.h"

void Cmd_Store_Teleport_f (edict_t *ent)
{
	if (ent->solid == SOLID_NOT)
	{
       safe_centerprintf (ent, "You are not in the game yet!!!\n");
	   return;
	}
	
	VectorCopy (ent->s.origin, ent->client->teleport_origin);
	VectorCopy (ent->s.angles, ent->client->teleport_angles);

	ent->client->teleport_stored = true;

	safe_centerprintf (ent, "Invisible Teleport in place!\n");

}

/*
==================
Cmd_Load_Teleport_f
==================
*/

void Cmd_Load_Teleport_f (edict_t *ent)
{
	int		i;

	if (ent->solid == SOLID_NOT)
	{
       safe_centerprintf (ent, "You are not in the game yet!!!\n");
	   return;
	}

	if (!ent->deadflag)
	{
		if (ent->client->teleport_stored)
		{


	if (ent->client->pers.currentcash > 0){
		safe_centerprintf (ent, "teleporting not allowed while holding cash!\n");
        return;
	}

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SFXSMOKE);
			gi.WritePosition (ent->s.origin);
			gi.WriteByte (34);
			gi.WriteByte (0);
            gi.multicast (ent->s.origin, MULTICAST_PVS);

					
//GHOSTZOID - START HOOK
		    if (ent->grapple_out == true)
            KPQ2PlayerResetGrapple(ent);
//GHOSTZOID - END HOOK

			// unlink to make sure it can't possibly interfere with KillBox

			gi.unlinkentity (ent);

			VectorCopy (ent->client->teleport_origin, ent->s.origin);
			VectorCopy (ent->client->teleport_origin, ent->s.old_origin);
			ent->s.origin[2] += 10;

			// clear the velocity and hold them in place briefly
			VectorClear (ent->velocity);
			ent->client->ps.pmove.pm_time = 160>>3;		// hold time
			ent->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

			// draw the teleport splash on the player
			ent->s.event = EV_PLAYER_TELEPORT;

					// set angles
			for (i=0 ; i<3 ; i++)
			ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(ent->client->teleport_angles[i] - ent->client->resp.cmd_angles[i]);

			VectorClear (ent->s.angles);
			VectorClear (ent->client->ps.viewangles);
			VectorClear (ent->client->v_angle);

					// kill anything at the destination
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_BFG_EXPLOSION);
			gi.WritePosition (ent->s.origin);
			gi.multicast (ent->s.origin, MULTICAST_PHS);

			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SFXSMOKE);
			gi.WritePosition (ent->s.origin);
			gi.WriteByte (34);
			gi.WriteByte (0);
            gi.multicast (ent->s.origin, MULTICAST_PVS);

					
					
			KillBox (ent);

			gi.linkentity (ent);

		}

		else
			safe_centerprintf (ent, "You don't be have a location stored\n");
	}
	
	else
		safe_centerprintf (ent, "Sorry. Can't be teleported when dead.\n");

 }

/*--------------------------------------------------------------------------
 * just here to help old map conversions
 *--------------------------------------------------------------------------*/

static void old_teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;
	vec3_t		forward;

	if (!other->client)
		return;

	dest = G_Find (NULL, FOFS(targetname), self->target);

	if (!dest)
	{
		gi.dprintf ("Couldn't find destination %s\n",self->target);
		return;
	}
//GHOSTZOID - START HOOK
		if (other->grapple_out == true)
        KPQ2PlayerResetGrapple(other);
//GHOSTZOID - - END HOOK
	
	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
//	other->s.origin[2] += 10;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_EXPLOSION);
	gi.WritePosition (other->s.origin);
	gi.multicast (other->s.origin, MULTICAST_PHS);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SFXSMOKE);
	gi.WritePosition (other->s.origin);
	gi.WriteByte (54);
	gi.WriteByte (0);
    gi.multicast (other->s.origin, MULTICAST_PVS);


	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
    gi.sound(other, CHAN_AUTO, snd_fry34, 1, ATTN_NORM, 0);

    //gi.positioned_sound(other->s.origin, other, CHAN_AUTO, snd_fry34 , 1, 1, 0);

//	self->enemy->s.event = EV_PLAYER_TELEPORT;
//	other->s.event = EV_OTHER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	other->s.angles[PITCH] = 0;
	other->s.angles[YAW] = dest->s.angles[YAW];
	other->s.angles[ROLL] = 0;
	VectorCopy (dest->s.angles, other->client->ps.viewangles);
	VectorCopy (dest->s.angles, other->client->v_angle);

	// give a little forward velocity
	AngleVectors (other->client->v_angle, forward, NULL, NULL);
	VectorScale(forward, 200, other->velocity);

	// kill anything at the destination
	if (!KillBox (other))
	{
	}

	gi.linkentity (other);
}



//=================================================================================



/*QUAKED trigger_teleport (0.5 0.5 0.5) ?
Players touching this will be teleported
*/
void SP_trigger_teleport (edict_t *ent)
{
	edict_t *s;
	int i;

	if (!ent->target)
	{
		gi.dprintf ("there is a q3 teleport without a targetname.\n");
		G_FreeEdict (ent);
		return;
	}

	ent->svflags |= SVF_NOCLIENT;
	ent->solid = SOLID_TRIGGER;
	ent->touch = old_teleporter_touch;
	gi.setmodel (ent, ent->model);
    gi.linkentity (ent);


	// noise maker and splash effect dude
	s = G_Spawn();

	ent->enemy = s;

	s->movetype = MOVETYPE_NONE;
	s->solid = SOLID_NOT;
	VectorSet (s->mins, -16, -16, -24);
	VectorSet (s->maxs,  16,  16,  48);

    for (i = 0; i < 3; i++)
		s->s.origin[i] = ent->mins[i] + (ent->maxs[i] - ent->mins[i])/2;

	s->s.sound = gi.soundindex ("elechum.wav");
	gi.linkentity(s);
	
}


/*QUAKED info_teleport_destination (0.5 0.5 0.5) (-16 -16 -24) (16 16 32)
Point trigger_teleports at these.
*/
void SP_info_teleport_destination (edict_t *ent)
{
	ent->s.origin[2] += 16;
}




void teleporter_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t		*dest;
	int			i;

	if (!(other->client))
		return;

	dest = G_Find (NULL, FOFS(targetname), self->target);

	if (!dest)
	{
		gi.dprintf ("Couldn't find destination\n");
		return;
	}
//GHOSTZOID - START HOOK
		if (other->grapple_out == true)
        KPQ2PlayerResetGrapple(other);
//GHOSTZOID - END HOOK

	// unlink to make sure it can't possibly interfere with KillBox
	gi.unlinkentity (other);

	VectorCopy (dest->s.origin, other->s.origin);
	VectorCopy (dest->s.origin, other->s.old_origin);
	other->s.origin[2] += 10;

	// clear the velocity and hold them in place briefly
	VectorClear (other->velocity);
	other->client->ps.pmove.pm_time = 160>>3;		// hold time
	other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;

	// draw the teleport splash at source and on the player
	self->owner->s.event = EV_PLAYER_TELEPORT;
	other->s.event = EV_PLAYER_TELEPORT;

	// set angles
	for (i=0 ; i<3 ; i++)
		other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

	VectorClear (other->s.angles);
	VectorClear (other->client->ps.viewangles);
	VectorClear (other->client->v_angle);

	// kill anything at the destination
	KillBox (other);

	gi.linkentity (other);
}

/*QUAKED misc_teleporter (1 0 0) (-32 -32 -24) (32 32 -16)
Stepping onto this disc will teleport players to the targeted misc_teleporter_dest object.
*/
void SP_misc_teleporter (edict_t *ent)
{

	edict_t		*trig;

	if (!ent->target)
	{
		gi.dprintf ("teleporter without a target.\n");
		G_FreeEdict (ent);
		return;
	}

    ent->solid = SOLID_TRIGGER;

	gi.setmodel (ent, "models/objects/dmspot/tris.md2");
	ent->s.skinnum = 1;
	ent->s.effects = EF_TELEPORTER;
	ent->s.sound = gi.soundindex ("world/amb10.wav");
	ent->solid = SOLID_BBOX;

	VectorSet (ent->mins, -32, -32, -24);
	VectorSet (ent->maxs, 32, 32, -16);
	gi.linkentity (ent);

	trig = G_Spawn ();
	trig->touch = teleporter_touch;
	trig->solid = SOLID_TRIGGER;
	trig->target = ent->target;
	trig->owner = ent;
	VectorCopy (ent->s.origin, trig->s.origin);
	VectorSet (trig->mins, -8, -8, 8);
	VectorSet (trig->maxs, 8, 8, 24);
	gi.linkentity (trig);
	
}

void SP_inv_misc_teleporter (edict_t *ent)
{
	edict_t		*trig;

	if (!ent->target)
	{
		gi.dprintf ("teleporter without a target.\n");
		G_FreeEdict (ent);
		return;
	}

	ent->solid = SOLID_TRIGGER;
//	gi.setmodel (ent, "models/objects/dmspot/tris.md2");
//	ent->s.skinnum = 1;
//	ent->s.effects = EF_TELEPORTER;
//	ent->s.sound = gi.soundindex ("world/amb10.wav");
//	ent->solid = SOLID_BBOX;

	VectorSet (ent->mins, -32, -32, -24);
	VectorSet (ent->maxs, 32, 32, -16);
	gi.linkentity (ent);

	trig = G_Spawn ();
	trig->touch = teleporter_touch;
	trig->solid = SOLID_TRIGGER;
	trig->target = ent->target;
	trig->owner = ent;
	VectorCopy (ent->s.origin, trig->s.origin);
	VectorSet (trig->mins, -8, -8, 8);
	VectorSet (trig->maxs, 8, 8, 24);
	gi.linkentity (trig);
	
}


/*QUAKED misc_teleporter_dest (1 0 0) (-32 -32 -24) (32 32 -16)
Point teleporters at these.
*/
void SP_misc_teleporter_dest (edict_t *ent)
{
	gi.setmodel (ent, "models/objects/dmspot/tris.md2");
	ent->s.skinnum = 0;
	ent->solid = SOLID_BBOX;
//	ent->s.effects |= EF_FLIES;
	VectorSet (ent->mins, -32, -32, -24);
	VectorSet (ent->maxs, 32, 32, -16);
	gi.linkentity (ent);
}

void SP_inv_misc_teleporter_dest (edict_t *ent)
{
//	gi.setmodel (ent, "models/objects/dmspot/tris.md2");
//	ent->s.skinnum = 0;
//	ent->solid = SOLID_BBOX;
//	ent->s.effects |= EF_FLIES;
	VectorSet (ent->mins, -32, -32, -24);
	VectorSet (ent->maxs, 32, 32, -16);
	gi.linkentity (ent);
}


void body_gib (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject);


void SP_dm_fixtarget(edict_t *ent)
{

	edict_t		*trig;

    int i;

    ent->classname = "dm_fixtarget";

	if (!ent->target)
	{

       ent->target = G_CopyString( "deadmanteleport1" );
	   gi.dprintf ("\nDead Man Teleport 1 is in place.\n");

	}


/*
    VectorSet (ent->mins, -16, -16, -24);
    VectorSet (ent->maxs,  16,  16,  48);
	
	gi.setmodel (ent, "models/objects/dmspot/tris.md2");

    ent->s.skinnum = 1;
	ent->s.effects = EF_FLIES; //EF_TELEPORTER;
    ent->s.sound = gi.soundindex ("world/amb10.wav");

    ent->solid = SOLID_NOT;
	
	ent->movetype = MOVETYPE_BOUNCE;

*/

	ent->solid = SOLID_TRIGGER;

	VectorSet (ent->mins, -40, -48, -14);
	VectorSet (ent->maxs, 40, 48, 14);		

	ent->s.effects = EF_FLIES + EF_FLASHLIGHT; //EF_TELEPORTER;

	ent->s.skinnum = ent->skin;
 	memset(&(ent->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	ent->s.num_parts++;
	ent->s.model_parts[0].modelindex = gi.modelindex("models/props/louie/body.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[0].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/body.mdx", &ent->s.model_parts[0]);	

	ent->s.num_parts++;
	ent->s.model_parts[1].modelindex = gi.modelindex("models/props/louie/head.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[1].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/body.mdx", &ent->s.model_parts[1]);	

	ent->s.num_parts++;
	ent->s.model_parts[2].modelindex = gi.modelindex("models/props/louie/legs.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[2].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/legs.mdx", &ent->s.model_parts[2]);	

	ent->die = body_gib;
	ent->takedamage = DAMAGE_YES;

	if (!ent->health)
		ent->health = 50;
	
	ent->movetype = MOVETYPE_BOUNCE;

	ent->s.renderfx2 |= RF2_DIR_LIGHTS;

	ent->surfacetype = SURF_FABRIC;


	gi.linkentity (ent);



	trig = G_Spawn ();
	trig->touch = teleporter_touch;
	trig->solid = SOLID_TRIGGER;
	trig->target = ent->target;
	trig->owner = ent;
	VectorCopy (ent->s.origin, trig->s.origin);
	VectorSet (trig->mins, -8, -8, 8);
	VectorSet (trig->maxs, 8, 8, 24);
	gi.linkentity (trig);




}


void SP_dm_fixtarget2(edict_t *ent)
{

	edict_t		*trig;

    int i;

    ent->classname = "dm_fixtarget2";

	if (!ent->target)
	{

       ent->target = G_CopyString( "deadmanteleport2" );
	   gi.dprintf ("\nDead Man Teleport 2 is in place.\n");

	}


/*
    VectorSet (ent->mins, -16, -16, -24);
    VectorSet (ent->maxs,  16,  16,  48);
	
	gi.setmodel (ent, "models/objects/dmspot/tris.md2");

    ent->s.skinnum = 1;
	ent->s.effects = EF_FLIES; //EF_TELEPORTER;
    ent->s.sound = gi.soundindex ("world/amb10.wav");

    ent->solid = SOLID_NOT;
	
	ent->movetype = MOVETYPE_BOUNCE;

*/
    ent->solid = SOLID_TRIGGER;

	VectorSet (ent->mins, -40, -48, -14);
	VectorSet (ent->maxs, 40, 48, 14);		

	ent->s.effects = EF_FLIES + EF_FLASHLIGHT; //EF_TELEPORTER;

	ent->s.skinnum = ent->skin;
 	memset(&(ent->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
	ent->s.num_parts++;
	ent->s.model_parts[0].modelindex = gi.modelindex("models/props/louie/body.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[0].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/body.mdx", &ent->s.model_parts[0]);	

	ent->s.num_parts++;
	ent->s.model_parts[1].modelindex = gi.modelindex("models/props/louie/head.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[1].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/body.mdx", &ent->s.model_parts[1]);	

	ent->s.num_parts++;
	ent->s.model_parts[2].modelindex = gi.modelindex("models/props/louie/legs.mdx");
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		ent->s.model_parts[2].skinnum[i] = ent->s.skinnum;
	gi.GetObjectBounds("models/props/louie/legs.mdx", &ent->s.model_parts[2]);	

	ent->die = body_gib;
	ent->takedamage = DAMAGE_YES;

	if (!ent->health)
		ent->health = 50;
	
	ent->movetype = MOVETYPE_BOUNCE;

	ent->s.renderfx2 |= RF2_DIR_LIGHTS;

	ent->surfacetype = SURF_FABRIC;


	gi.linkentity (ent);



	trig = G_Spawn ();
	trig->touch = teleporter_touch;
	trig->solid = SOLID_TRIGGER;
	trig->target = ent->target;
	trig->owner = ent;
	VectorCopy (ent->s.origin, trig->s.origin);
	VectorSet (trig->mins, -8, -8, 8);
	VectorSet (trig->maxs, 8, 8, 24);
	gi.linkentity (trig);




}


void SP_dm_fixtargetname(edict_t *ent)
{

    ent->classname = "dm_fixtargetname";

    ent->targetname = G_CopyString( "deadmanteleport1" );

    VectorSet (ent->mins, -16, -16, -24);
    VectorSet (ent->maxs,  16,  16,  48);
	
	gi.setmodel (ent, "models/objects/dmspot/tris.md2");

    ent->s.skinnum = 2;
//    ent->s.effects = EF_TELEPORTER;
//    ent->s.sound = gi.soundindex ("world/amb10.wav");
    ent->solid = SOLID_NOT;
	
    //MOVETYPE_WALK
	ent->movetype = MOVETYPE_BOUNCE;

	gi.linkentity (ent);


}


void SP_dm_fixtargetname2(edict_t *ent)
{

    ent->classname = "dm_fixtargetname2";

    ent->targetname = G_CopyString( "deadmanteleport2" );

    VectorSet (ent->mins, -16, -16, -24);
    VectorSet (ent->maxs,  16,  16,  48);
	
	gi.setmodel (ent, "models/objects/dmspot/tris.md2");

    ent->s.skinnum = 2;
//    ent->s.effects = EF_TELEPORTER;
//    ent->s.sound = gi.soundindex ("world/amb10.wav");
    ent->solid = SOLID_NOT;
	
    //MOVETYPE_WALK
	ent->movetype = MOVETYPE_BOUNCE;

	gi.linkentity (ent);


}


